#include "Bar.h"



Bar::Bar()
{
}


Bar::~Bar()
{
}

bool Bar::loadMTL(char* modelFilename, char* mtlFilename, int renderingShape)
{
	return Model::loadMTL(modelFilename, mtlFilename, renderingShape);
}

void Bar::SetLights(PointLight* one, PointLight* two)
{
	_PointOne = one;
	_PointTwo = two;
}

void Bar::render(Vector3 position)
{
	std::fill(std::begin(shadowMatrix), std::end(shadowMatrix), 0.0);

	if (_PointOne->GetIsOn())
	{
		Shadow::generateShadowMatrix(shadowMatrix, &_PointOne->GetPosition()[0], floorVerts);
	}

	if (_PointTwo->GetIsOn())
	{
		Shadow::generateShadowMatrix(shadowMatrix, &_PointTwo->GetPosition()[0], floorVerts);
	}

	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);

	glPushMatrix();
		glColor3f(0.1f, 0.1f, 0.1f); // Shadow's colour
		glPushMatrix();
			glMultMatrixf((GLfloat *)shadowMatrix);
			glTranslatef(position.x, position.y, position.z);
			Model::render();
		glPopMatrix();
	glPopMatrix();

	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);

	glPushMatrix();
		glTranslatef(position.x, position.y, position.z);
		Model::render();
	glPopMatrix();
}
